/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.util;

import javax.vecmath.Point3d;
import replicatorg.machine.model.AxisId;

public class Point5d {
    private static final int DIMENSIONS = 5;
    private final double[] values = new double[5];

    public Point5d() {
        this(0.0, 0.0, 0.0, 0.0, 0.0);
    }

    public Point5d(double x, double y, double z, double a, double b) {
        this.values[0] = x;
        this.values[1] = y;
        this.values[2] = z;
        this.values[3] = a;
        this.values[4] = b;
    }

    public Point5d(double x, double y, double z) {
        this.values[0] = x;
        this.values[1] = y;
        this.values[2] = z;
        this.values[3] = 0.0;
        this.values[4] = 0.0;
    }

    public Point5d(Point5d p) {
        System.arraycopy(p.values, 0, this.values, 0, 5);
    }

    public double axis(AxisId axis) {
        return this.values[axis.getIndex()];
    }

    public void setAxis(AxisId axis, double v) {
        this.values[axis.getIndex()] = v;
    }

    public double get(int idx) {
        return this.values[idx];
    }

    public void set(int idx, double v) {
        this.values[idx] = v;
    }

    public double x() {
        return this.values[0];
    }

    public double y() {
        return this.values[1];
    }

    public double z() {
        return this.values[2];
    }

    public double a() {
        return this.values[3];
    }

    public double b() {
        return this.values[4];
    }

    public void setX(double x) {
        this.values[0] = x;
    }

    public void setY(double y) {
        this.values[1] = y;
    }

    public void setZ(double z) {
        this.values[2] = z;
    }

    public void setA(double a) {
        this.values[3] = a;
    }

    public void setB(double b) {
        this.values[4] = b;
    }

    public Point3d get3D() {
        return new Point3d(this.values);
    }

    public void add(Point5d p1) {
        int idx = 0;
        while (idx < 5) {
            int n = idx;
            this.values[n] = this.values[n] + p1.values[idx];
            ++idx;
        }
    }

    public void sub(Point5d p1) {
        int idx = 0;
        while (idx < 5) {
            int n = idx;
            this.values[n] = this.values[n] - p1.values[idx];
            ++idx;
        }
    }

    public void sub(Point5d p1, Point5d p2) {
        int idx = 0;
        while (idx < 5) {
            this.values[idx] = p1.values[idx] - p2.values[idx];
            ++idx;
        }
    }

    public void div(Point5d p1, Point5d p2) {
        int idx = 0;
        while (idx < 5) {
            this.values[idx] = p1.values[idx] / p2.values[idx];
            ++idx;
        }
    }

    public void mul(Point5d p1, Point5d p2) {
        int idx = 0;
        while (idx < 5) {
            this.values[idx] = p1.values[idx] * p2.values[idx];
            ++idx;
        }
    }

    public void round() {
        int idx = 0;
        while (idx < 5) {
            this.values[idx] = Math.round(this.values[idx]);
            ++idx;
        }
    }

    public void round(Point5d excess) {
        int idx = 0;
        while (idx < 5) {
            double rounded = Math.round(this.values[idx]);
            excess.values[idx] = this.values[idx] - rounded;
            this.values[idx] = rounded;
            ++idx;
        }
    }

    public void absolute() {
        int idx = 0;
        while (idx < 5) {
            this.values[idx] = Math.abs(this.values[idx]);
            ++idx;
        }
    }

    public double distance(Point5d p) {
        double acc = 0.0;
        int idx = 0;
        while (idx < 5) {
            double delta = this.values[idx] - p.values[idx];
            acc += delta * delta;
            ++idx;
        }
        return Math.sqrt(acc);
    }

    public double length() {
        double acc = 0.0;
        int idx = 0;
        while (idx < 5) {
            double delta = this.values[idx];
            acc += delta * delta;
            ++idx;
        }
        return Math.sqrt(acc);
    }

    public double magnitude() {
        double acc = 0.0;
        int idx = 0;
        while (idx < 5) {
            double delta = this.values[idx];
            acc += delta * delta;
            ++idx;
        }
        return Math.sqrt(acc);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append('(');
        sb.append(this.values[0]);
        int idx = 1;
        while (idx < 5) {
            sb.append(',');
            sb.append(this.values[idx]);
            ++idx;
        }
        sb.append(')');
        return sb.toString();
    }
}

